<?php

namespace Mnv\Models\Cars;

use Mpdf\Mpdf;
use Mpdf\MpdfException;
use Mnv\Core\Locale\I18N;


class PricePdf
{
    private $pdfSettings = [
        'mode' => 'utf-8',
        'format' => 'A4-P',
        'orientation' => 'P',
        'default_font_size' => 6,
        'default_font' => 'tacticsans',
        'margin_left' => 0, 'margin_right' => 0, 'margin_top' => 0, 'margin_bottom' => 0, 'margin_header' => 0, 'margin_footer' => 0
    ];
    protected $pdf;
    private $modelId;
    private $models;

    private $css;
    private $html;
    private $htmlFooter;


    public function __construct($modelId)
    {
        $this->models = new GenerationPriceForPdf();

        $this->modelId = $modelId;

        $title = I18N::locale("Комплектации и цены", "Uskunalar va narxlar", "Options and prices");
        $this->pdf = new Mpdf($this->pdfSettings);
        $this->pdf->SetTitle($title);
        $this->pdf->SetAuthor('Официальный импортер CHERY в Узбекистане');
        $this->pdf->SetDisplayMode('fullpage');
        $this->pdf->charset_in = 'utf-8';
        $this->pdf->mirrorMargins = 0;
        $this->pdf->defaultheaderfontsize = 8;
        $this->pdf->defaultheaderfontstyle = 'blank';
        $this->pdf->img_dpi = 300;
        $this->pdf->defaultheaderline = 1;

        /** ПОЛУЧИТЬ МОДЕЛЬ */
        $this->models->getModel($this->modelId);
        /** ПОЛУЧИТЬ СВОЙСТВА СПЕЦИФИКАЦИЙ */
        $this->models->getFeaturesGroup();
        $this->models->getEquipmentsGroup($this->modelId);
        $this->models->getFeatureOptionsGroup();
    }


    public function generationHtml(): PricePdf
    {
        /** всякий случай */
        $this->cssPdf();

        $this->html = '<html>';
        $this->html .= '<head>';
        $this->html .= '<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>';
        $this->html .= '<link type="text/css" href="'.ASSETS_URL.'/pdf/css/pdf.css" rel="stylesheet"/>';
        $this->html .= '<title>'.$this->models->model->name.'</title>';
        $this->html .= '</head>';
        $this->html .= '<body>';

        if (!empty($this->models->model)) {

//            $this->html .= $this->css;

            /** header background image */
            if (isset($this->models->model->banner) && !empty($this->models->model->banner)) {
                $this->html .= '<div class="header" border="0" style=" width: 100%; display: block; position: relative;"><img src="' . $this->models->model->banner . '"  style=" width: 100%; "/></div>';
            }
            /** Спецификация */
            $this->specifications();

            /** Цвета экстерьера */
            $this->bodyColor();

            /** Комплектации и цены */
            $this->optionsAndPrices();

            /** Описание звездочек */
//            $this->html .= '<div style="width:100%;padding: 10px 20px;"><p style="color: #1a1919">' . $this->models->model->content . '</p></div>';

        } else {

            /** если по ошибке пришел не тот ID или попытка взлома */
            $this->html = '<div style="width:100%;padding: 10px 20px;"><h2 style="color:#ba242a;">Такой модели не существует</h2></div>';
        }

        $this->html .= '</body>';
        $this->html .= '</html>';
//        $this->htmlFooter = '<div><img src="'.ASSETS_ROOT.'/pdf/img/footer.jpg" width="100%" height="100%" style="max-height: 200px;"/></div>';

        return $this;
    }

    public function save($SITE_LANG = null): bool
    {
        $this->pdf->WriteHTML($this->html);
//        $this->pdf->SetHTMLFooter($this->htmlFooter);

        try {
            if (!is_null($SITE_LANG) || !empty($SITE_LANG)) {
                $this->pdf->Output(GLOBAL_ROOT . '/' .$SITE_LANG. '/pdf/' . str_replace(" ", "_", $this->models->model->name) . '_price.pdf', 'F');
            } else {
                $this->pdf->Output(GLOBAL_ROOT . '/pdf/' . str_replace(" ", "_", $this->models->model->name) . '_price.pdf', 'F');
            }
            return $this->models->updateModelColPdf($this->modelId, SITE_URL . '/pdf/' . str_replace(" ", "_", $this->models->model->name) . '_price.pdf');
        } catch (MpdfException $e) {
            print_r($e->getMessage());
        }
    }

    /** СПЕЦИФИКАЦИЙ */
    private function specifications()
    {
        $title = I18N::locale("Спецификация", "Tashqi ranglar", "Specification");
        $this->html .= '<div class="content"><h2 style="color:#000;"> ' . $title . '</h2></div>';

        /** СВОЙСТВА СПЕЦИФИКАЦИЙ */
        $this->html .= '<table class="feature_specifications" border="0"><tbody>';
        if (isset($this->models->features) && !empty($this->models->features)) {
            foreach ($this->models->features as $feature) {
                $this->html .= '<tr>';
                $this->html .= '<td align="left" style="padding:10px 20px 2px 20px;text-align: left;" colspan="' . (count($this->models->modificationIds) + 1) . '"><h4 style="color: #ba242a;">' . $feature->name . '</h4></td>';
                $this->html .= '</tr>';
                $i = 0;
                foreach ($feature->params as $param) {
                    $this->html .= '<tr style=" background-color:';
                    if ($i % 2 == 0) {
                        $this->html .= '#dddedd';
                    }
                    $this->html .= '">';
                    $this->html .= '<td align="left" style="padding: 2px 10px 2px 20px;">' . $param->name . '</td>';
                    foreach ($param->values as $value) {
                        $this->html .= '<td align="left" style="padding: 2px 10px;">' . $value->value . '</td>';
                    }
                    $this->html .= '</tr>';
                    $i++;
                }
                $this->html .= '</tr>';
            }
        }
        $this->html .= '</tbody></table>';
    }

    /** Цвета экстерьера */
    private function bodyColor()
    {
        $title = I18N::locale("Цвета экстерьера", "Tashqi ranglar", "Exterior colors");
        $this->html .= '<div class="colors"><h2>' . $title . '</h2></div>';

        $this->html .= '<div class="color-base">';
        foreach ($this->models->model->colors as $color) {
            $this->html .= '<div class="color-base-card color-card-' . count($this->models->model->colors) . '">';
            $this->html .= '<img src="' . $color->original . '" style="width:100%;" />';
            $this->html .= '<p class="text-image"><b>' . $color->colorName . '</b></p>';
            $this->html .= '</div>';
        }
        $this->html .= '</div>';
    }

    /** Комплектации и цены */
    private function optionsAndPrices()
    {
        $countEquipments = (isset($this->models->equipments) && !empty($this->models->equipments)) ? count($this->models->equipments) : 0;
        $this->html .= '<div class="prices"><h2>Комплектации и цены ' . $this->models->model->name . '</h2></div>';

        /** название комплектации */
        $this->html .= '<table border="0" width="100%"><thead><tr>';
        if (isset($this->models->equipments) && !empty($this->models->equipments)) {
            $this->html .= '<th width="400" style="padding: 10px 5px 4px 20px;text-align: left; color: #ba242a;">Комплектации, 2022 модельный год</th>';
            foreach ($this->models->equipments as $equipment) {
                $this->html .= '<th align="center" width="100" style="padding: 2px 10px;color:#ba242a;">' . $equipment->title . '</th>';
            }
        }
        $this->html .= '</tr></thead><tbody>';

        /** модификацию комплектации */
        if (isset($this->models->equipments) && !empty($this->models->equipments)) {
            $this->html .= '<tr><td width="400" style="padding: 10px 5px 4px 20px;text-align: left;"></td>';
            foreach ($this->models->equipments as $equipment) {
                $this->html .= '<td align="center" width="100" style="padding: 2px 10px;color: #ba242a;">' . $equipment->modification . '</td>';
            }
            $this->html .= '</tr>';

            /** цена комплектации */
            $this->html .= '<tr>';
            $this->html .= '<td width="400" style="padding: 10px 5px 4px 20px;text-align: left;"><b style="color:#000;">Рекомендованная максимальная цена перепродажи****</b></td>';
            foreach ($this->models->equipments as $equipment) {
                $this->html .= '<td align="center" width="100" style="padding: 2px 10px;"><b style="color:#000;">' . number_format($equipment->price, 0, ".", " ") . '</b></td>';
            }
            $this->html .= '</tr>';
        }

        /** опции комплектации */
        if (!empty($this->models->featureOptions)) {
            foreach ($this->models->featureOptions as $featureOption) {
                $this->html .= '<tr >';
                $this->html .= '<td align="left" style="padding:20px 20px 2px 20px;" colspan="' . ($countEquipments + 1) . '"><h4 style="color: #ba242a;" >' . $featureOption->name . '</h4></td>';
                $this->html .= '</tr>';
                $b = 0;
                if (!empty($featureOption->options)) {
                    foreach ($featureOption->options as $option) {
                        $this->html .= '<tr style="background-color:';
                        if ($b % 2 == 0) {
                            $this->html .= '#dddedd';
                        }
                        $this->html .= '">';
                        $this->html .= '<td align="left" width="400" style="padding: 2px 10px 2px 20px;">' . $option->name . '</td>';
                        foreach ($this->models->equipments as $equipment) {
                            $this->html .= '<td align="center" width="100" style="padding: 2px;">';
                            if (isset($option->equipments[$equipment->equipmentId])) {
                                $this->html .= '<span><img src="' . ASSETS_ROOT . '/pdf/img/yes.svg" width="6" style="max-width: 8px;"/></span>';
                            } else {
                                $this->html .= '<span><img src="' . ASSETS_ROOT . '/pdf/img/no.svg" width="8" style="max-width: 8px;"/></span> ';
                            }

                            $this->html .= '</td>';
                        }
                        $this->html .= '</tr>';
                        $b++;
                    }
                }
            }
        }
        $this->html .= '</tbody></table>';
    }

    private function cssPdf()
    {
        $this->css = '
        @page :first { background-image-resize:4; background-position: top center; background-repeat: no-repeat; }

        body { font-family: tacticsans, sans-serif; }
        * { font-family: tacticsans; font-size: 8px;}
        h2 { font-family: tacticsans B; font-size:19px;margin: 0;}
        h4 { font-family: tacticsans B; font-size:9px;margin: 0;}
        p { font-family: tacticsans; font-size:8px;}
        p.text-image { font-family: tacticsans B; font-size:10px;}
        .text-bold { font-family: tacticsans B;}
        
        div.header { width: 100%;}
        div.content { margin-top: -20px; padding: 0px 0px 0px 20px;width: 100%; }
        div.colors, div.prices { margin-top: 10px;padding: 0px 0px 0px 20px; width: 100%; }
        div.colors h2, div.prices h2 { color:#000; font-size:18px; }
        
        
        
        table { width: 100%; margin-bottom: 1.25rem; color: #333; border-collapse: collapse; }
        tbody { list-style: none; margin: 0; padding: 0; width: 100%; max-width: 200px; }
        table tbody tr:nth-of-type(odd) { background-color: #dddedd; }
        /*table tbody tr:nth-of-type(odd) td { background-color: #dddedd; }*/
        table td, table th { padding: 10px 5px 4px 20px; vertical-align: middle; border: 0px solid #ffffff; text-align: left }
        /*table td, table th, table tr { transition: background-color ease-in-out .15s; }*/
        
        table.feature_specifications {
            margin-top: 0px
        }
        table.feature_specifications tbody tr {
            background-color: #ffffff
        }
        table.feature_specifications tbody tr:first-child td {
            padding: 0px 0px 2px 20px;
        }
        table.feature_specifications tbody tr td h4 { color: #ba242a; }
        
        div.color-base { width: 100%;text-align: center }
        
        div.color-base-card { float: left;text-align: center;padding: 10px 20px; }
        div.color-card-1 { width: 220px; }
        div.color-card-2 { width: 220px; }
        div.color-card-3 { width: 220px; }
        div.color-card-4 { width: 155px; }
        div.color-card-5 { width: 220px; }
        div.color-card-6 { width: 220px; }
        div.color-card-7 { width: 25%; }
        div.color-card-8 { width: 220px; }
        div.color-card-9 { width: 220px; }
        div.color-card-10 { width: 220px; }
        div.color-card-11 { width: 25% }
        div.color-card-12 { width: 220px; }
        ';
    }

}