<?php

namespace Mnv\Models\Cars;

use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Core\Model;
use Mnv\Http\Request;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;

/**
 * Class Specifications
 * @package Mnv\Models\Cars
 */
class Specifications extends Model
{
    protected string $table = 'car_specifications';

    protected string $primaryKey = 'specificationId';

    protected string $orderBy = 'orderBy ASC';


    public $specificationIds;
    public $modelIds;
    public $params;


    public function __construct(Request $request)
    {
        $this->id                   = $request->get('id');
        $this->data                 = $request->get('specification');
        $this->specificationIds     = $request->get('specificationIds');
        $this->modelIds   = $request->get('modelIds');
        /** Спецификации */
        $this->params = $request->get('params', '');
    }

    private function sortBy()
    {
        if (!empty($this->filter['query'])) {
            connect()->grouped(function($q) {
                $q->like('name', "%" . $this->filter['query'] . "%");
            });
        }
        if (!empty($this->filter['status'])) {
            connect()->where('status', $this->filter['status']);
        }

        connect()->whereNull('parentId',  false);
    }


    public function all($limit, $page)
    {
        $this->sortBy();

        return parent::all($limit, $page);
    }

    /**
     * Получить кол-во свойств `$this->total`
     */
    public function total(): void
    {
        $this->sortBy();

        parent::total();
    }


    public function prepare(array $data, int $managerId): bool
    {

        $data['modifiedBy']   = $managerId;
        $data['modifiedOn']   = gmdate('Y-m-d H:i:s');

        if (empty($this->id)) {

            $data['addedBy'] = $managerId;
            $data['addedOn'] = gmdate('Y-m-d H:i:s');
            $data['orderBy'] = connect($this->table)->max('orderBy')->getValue() + 1;
            if ($this->id = $this->insert($data)) {
                return true;
            }
        }
        else {

            return $this->update($data);
        }

        return false;
    }


    /**
     * Удаление
     *
     * @return bool
     * @throws NotFoundException
     * @throws NoContentException
     * @throws DatabaseException
 */
    public function remove(): bool
    {
        /** удаление свойства */
        if (parent::remove()) {
            /** удаление спецификации */
            connect('car_specifications')->where('parentId', $this->id)->delete();
            connect('car_specifications_value')->where($this->primaryKey, $this->id)->delete();

            return true;
        }

        return false;
    }


    public function checkFileName(string $fileName)
    {
        // TODO: Implement checkFileName() method.
    }

    /** SPECIFICATIONS */

    /**
     * Функция возвращает варианты товара
     * @return array|null
     */
    public function specifications(): ?array
    {
        if (!empty($this->id)) {
            return connect('car_specifications')->where('parentId', $this->id)->orderBy('orderBy')->keyBy($this->primaryKey);
        }

        return [];
    }

    public function specification(int $specificationId)
    {
        if (!empty($specificationId)) {
            return connect('car_specifications')->where($this->primaryKey, $specificationId)->get('array');
        }

        return null;
    }

    public function addSpecification(array $specification, $managerId): int
    {
        $specification['parentId'] = $this->id;
        $specification['orderBy'] = 0;
        $specification['addedBy'] = $managerId;
        $specification['addedOn'] = gmdate('Y-m-d H:i:s');
        $specification['modifiedBy']   = $managerId;
        $specification['modifiedOn']   = gmdate('Y-m-d H:i:s');

        return connect('car_specifications')->insert($specification);
    }

    /**
     * @param int specificationId
     * @param array $specification
     */
    public function updateSpecification(int $specificationId, array $specification, $managerId): void
    {
        $specification['modifiedBy']   = $managerId;
        $specification['modifiedOn']   = gmdate('Y-m-d H:i:s');
        connect('car_specifications')->where($this->primaryKey, $specificationId)->update($specification);
    }

    public function removeSpecification(int $specificationId): void
    {
        connect('car_specifications')->where($this->primaryKey, $specificationId)->delete();
    }



}