<?php

namespace Mnv\Models;

use Mnv\Core\Model;
use Mnv\Http\Request;

/**
 * Class Cities
 * @package Mnv\Models
 */
class GeoCities extends Model
{
    /** @var string */
    protected string $table = 'geo_cities';

    /** @var string  */
    protected string $primaryKey = 'id';

    /** @var string  */
    protected string $orderBy = 'orderBy ASC';

    /** @var array  */
    public $ids = [];

    public function __construct(Request $request)
    {
        $this->id   = $request->get('id');
        $this->data = $request->get('city');
        $this->ids = $request->get('ids');
    }


    public function prepare(array $data, int $managerId): bool
    {
        $data['modifiedBy']    = $managerId;
        $data['modifiedOn']    = gmdate('Y-m-d H:i:s');

        if (empty($this->id)) {
            $data['addedBy'] = $managerId;
            $data['addedOn'] = gmdate('Y-m-d H:i:s');
            $data['orderBy'] = $this->getMaxValue('orderBy') + 1;

            if ($this->id = $this->insert($data)) {
                return true;
            }
        }
        else {
            return $this->update($data);
        }

        return false;
    }

    /**
     * @return array|false|mixed|string
     */
    public static function getSelectCities()
    {
        $countryList = array(0 => 'Выберите город');
        $countryList += connect()->table( 'geo_cities')->select('id, name')->orderBy('orderBy ASC')->pluck('name', 'id');

        return $countryList;
    }

    public static function getCityName($id)
    {
        return connect( 'geo_cities')->select('name')->where('id', $id)->getValue();
    }


}