<?php

namespace Mnv\Models;

use Mnv\Core\Model;
use Mnv\Http\Request;

/**
 * Class SubscribersUser
 * @package Mnv\Models\Users
 */
class Subscriber extends Model
{
    /**
     * Таблица, связанная с моделью.
     *
     * @var string
     */
    protected string $table = 'subscribe';
    /**
     * Первичный ключ для модели.
     *
     * @var string
     */
    protected string $primaryKey = 'userId';

    /**
     * @var string
     */
    protected string $orderBy = 'userId ASC';


    public function __construct(Request $request)
    {
        $this->id           = $request->get('id');
        $this->data         = $request->get('user');

        $this->sortBy       = $request->get('sortBy');
        $this->sortOrder    = $request->get('sortOrder');

    }

    protected function sorting()
    {
        if (!empty($this->filter['query'])) {
            connect()->grouped(function($q) {
                $q->like('email', "%" . $this->filter['query'] . "%")->orLike('phone',"%" . $this->filter['query'] . "%");
            });
        }
    }

    /**
     * Получение всех пользователей
     *
     * @param int $limit
     * @param int $page
     */
    public function all(int $limit, int $page)
    {
//        /** Фильтровать пользователей */
        $this->sorting();

        return parent::all($limit, $page);
    }

    /**
     * получение кол-во пользователей
     */
    public function total() : void
    {
        /** Фильтровать пользователей */
        $this->sorting();

        parent::total();
    }

    /**
     * Проверить на существование
     * @param string $field по какому полю проверять (`email` или `phone`)
     * @param string $param приходящий параметр для сравнения
     * @return bool
     */
    public function existSubscribe(string $field, string $param): bool
    {
        if (connect($this->table)->count('*')->where($field, $param)->getValue()) return true;

        return false;
    }

    /**
     * Проверка на совпадение email
     * @param string $email
     * @return string|null
     */
    public function checkEmailUser(string $email): ?string
    {
        if (!empty($this->id)) connect()->where('userId','<>', $this->id);
        if ($email = connect($this->table)->select('email')->where('email', $email)->getValue()) {
            return $email;
        }

        return null;
    }

    public function prepare(array $data): bool
    {
        if (empty($this->id)) {
            $data['registered'] = gmdate('Y-m-d H:i:s');
            return $this->insert($data);
        } else {
            return $this->update($data);
        }
    }




}