<?php

namespace Mnv\Modules\Cars;

use Mnv\Core\Locale\I18N;
use Mnv\Core\Uploads\ImageCollection;

/**
 * Class ConfiguratorPage
 * @package Mnv\Modules\Cars
 */
class ConfiguratorPage
{

    public array $models = [];

    /** STEPS */
    private function steps(): array
    {
        return array(
            ["step_id" => 0, "name" => I18N::locale("Выбор модели", "Modelni tanlash", "Choosing a model"),],
            ["step_id" => 1, "name" => I18N::locale("Двигатель и трансмиссия", "Dvigatel va transmissiya", "Engine and transmission")],
            ["step_id" => 2, "name" => I18N::locale("Комлектация", "Uskunalar", "Equipment")],
            ["step_id" => 3, "name" => I18N::locale("Цвета", "Ranglar", "Colors")],
            ["step_id" => 4, "name" => I18N::locale("Результаты", "Natijalar", "Results")]
        );
    }

    /** TEXT ELEMENTS */
    private function textElements(): array
    {
        return array(
            "price" => [I18N::locale("сум", "so'mdan", "sum"), I18N::locale("от", "", "from"), I18N::locale("Стоимость от", "Narxi", "Cost from")],
            "btn_prev_next" => [I18N::locale("Назад", "Orqaga", "Back"), I18N::locale("Далее", "Keyingi", "Further")],
            "any_btn" => [I18N::locale("Подробнее", "Batafsil", "More detailed"),],
            "colors" => [
                I18N::locale("Цвет кузова", "Tana rangi", "Body color"),
                I18N::locale("Цвет салона", "Ichki rang", "Interior color"),
                I18N::locale("Экстерьер", "Tashqi ko'rinishi", "Exterior"),
                I18N::locale("Интерьер", "Ichki makon", "Interior")
            ],
            "atention_color" => [
                 I18N::locale(
                     "*Изображение может не соответствовать выбранной комплектации. Цвет автомобиля может отличаться от представленного на данном сайте.",
                     "*Rasm tanlangan konfiguratsiyaga mos kelmasligi mumkin. Avtomobilning rangi ushbu saytda taqdim etilganidan farq qilishi mumkin.",
                     "*The image may not match the selected configuration. The color of the car may differ from the one shown on this website."
                 )
            ],
            "error_text" => [
                I18N::locale(
                    "Приносим свои извинения, данный сервис в разработке или на стадии наполнения",
                    "Biz uzr so'raymiz, ushbu xizmat ishlab chiqilmoqda yoki to'ldirish bosqichida",
                    "We apologize, this service is in development or at the filling stage"
                )
            ]
        );
    }

    /** Все модели по типу (Электро / Гибрид) */
    public function all()
    {
        $this->models['steps'] = $this->steps();
        $this->models['txt_elements'] = $this->textElements();

        $sections = connect('sections')->select('sectionId AS type_id, name AS type_name')->where('status', 'V')->where('typeContent', 'models')->where('parentId', 2)->orderBy('sectionId ASC')->getAll('array');
        $this->models['types'] = collect($sections)->map(function ($section) {
            $section['models'] = $this->models($section['type_id']);
            return $section;
        })->all();

    }

    /** Модели */
    public function models(int $sectionId): ?array
    {
        $models = connect('car_models')->select('modelId AS model_id, alias AS name')->where('status', 'V')->where('sectionId', $sectionId)->orderBy('publishedOn DESC')->getAll('array');
        return collect($models)->map(function ($model) {
            // Минимальная цена
            $model['min_price'] = $this->getMinPriceEquipments($model['model_id']);

            $images = $this->getFiles('car_model_images', 'modelId', $model['model_id']);
//            if (!empty($images['gallery'])) {
//                foreach ($images['gallery'] as $image) {
//                    if ($image['position'] == 'main') $model['image'] = $image['original'];
//                }
//            }
            if (!empty($images['general'])) {
                $model['image'] = $images['general']['original'];
            }

            // Модификации
            $model['modifications'] = $this->modifications($model['model_id']);

            return $model;
        })->filter()->all();
    }



    /** Модификации */
    public function modifications($modelId): ?array
    {
//        $modifications = connect('car_modifications')->select('modificationId AS modification_id, name, power, power_reserve, battery_capacity, engine, engine_capacity, transmissions, gear')->where('status', 'V')->where('modelId', $modelId)->orderBy('orderBy ASC')->getAll('array');
        $modifications = connect('car_modifications')->select('modificationId AS modification_id, name, power, power_reserve, engine, engine_capacity, transmissions, gear')->where('status', 'V')->where('modelId', $modelId)->orderBy('orderBy ASC')->getAll('array');
        return collect($modifications)->map(function ($modification) use ($modelId) {
            $modification['info'] = [
                [
                    "name" => I18N::locale("Двигатель", "Dvigatel", "Engine"),
                    "properties" => [
//                        $modification['name'],
                        $modification['power'],
                        $this->engineName($modification['engine'])
                    ]
                ], [
                    "name" => I18N::locale("Коробка передач", "Transmissiya", "Transmission"),
                    "properties"=> [
                        $this->transmissionName($modification['transmissions'])
                    ]
                ], [
                    "name" => I18N::locale("Привод", "Drayv", "Drive"),
                    "properties" => [
                        $this->gearName($modification['gear'])
                    ]
                ], [
                    "name" => I18N::locale("Запас хода", "Quvvat zaxirasi", "Power reserve"),
                    "properties" => [
                        $modification['power_reserve'],
                    ]
                ]
            ];

//            unset($modification['name'], $modification['power'], $modification['engine'], $modification['transmissions'], $modification['gear']);

            $modification['equipments']  = $this->equipments($modification['modification_id'], $modelId);
            if (!empty($modification['equipments'])) {
                $modification['specifications'] = $this->specifications($modification['modification_id']);

                return $modification;
            }

            return [];
        })->filter()->values()->all();
    }


    /** комплектации */
    public function equipments($modificationId, $modelId): ?array
    {
        if (!empty($modificationId)) {
            $equipments = connect('car_equipments')->select('equipmentId AS equipment_id, title AS name, price, oldPrice AS old_price, summary AS main_options')->where('status', 'V')->where('modificationId', $modificationId)->orderBy('orderBy ASC')->getAll('array');
            return collect($equipments)->map(function ($item) use ($modelId) {
                if (!empty($item['main_options'])) {
                    preg_match_all('~<li>(.*?)</li>~s', $item['main_options'], $matches);
                    if (!empty($matches[1])) {
                        $item['main_options'] = $matches[1];
                    }
                }
                $item['options'] = $this->options($item['equipment_id']);
                $item['exterior_colors'] = $this->getModelBColors($modelId);
                $item['interior_colors'] = $this->getModelIColors($modelId);

                return $item;
            })->all();
        }
    }


    /** Спецификация */
    public function specifications($modificationId): ?array
    {
        $specifications = connect('car_specifications')->select('specificationId AS ID, name')->orderBy('orderBy')->where('status', 'V')->whereNull('parentId',  false)->getAll('array');
        return collect($specifications)->map(function ($specification) use ($modificationId) {
            $properties = connect('car_specifications')->select('specificationId AS ID, parentId, name')->where('parentId', $specification['ID'])->whereNull('parentId',  true)->orderBy('orderBy ASC')->getAll('array');
            $properties = collect($properties)->map(function ($item) use ($modificationId) {
                $property = connect()->table('car_specifications_value')->select('value, unit')->where('specificationId', $item['ID'])->where('modificationId', $modificationId)->get('array');
                unset($item['ID']);
                unset($item['parentId']);
                if (!empty($property['value'])) {
                    $item['value'] = $property['value'];
                    $item['unit'] = $property['unit'];
                } else {
                    unset($item['name']);
                }

                return $item;
            })->filter()->values()->all();

            $specification['properties'] = $properties;
            return $specification;
        })->filter()->all();
    }


    /**
     * Опции комплектации
     * @param $equipmentId
     * @return array
     */
    private function options($equipmentId): ?array
    {
        $options = connect('car_options')->select('optionId, name')->orderBy('orderBy ASC')->where('status', 'V')->whereNull('parentId',  false)->indexKey('name')->getAll('array');
        return collect($options)->map(function ($option) use ($equipmentId) {
            $values = connect('car_options_value')->usingJoin('car_options AS ceo', 'optionId')->select('ceo.name')->where('ceo.parentId', $option['optionId'])->where('equipmentId', $equipmentId)->whereNull('ceo.parentId',  true)->getAll('array');
            $option['properties'] = collect($values)->map(function ($value) {
                return $value['name'];
            })->all();

            unset($option['optionId']);
            if (empty($option['properties'])) unset($option['name'], $option['properties']);

            return $option;
        })->filter()->values()->all();

    }


    /** РАБОТА С ФАЙЛАМИ / ИЗОБРАЖЕНИЕМ */

    /** Цвет кузова у модели */
    private function getModelBColors($modelId): array
    {
        $images = connect('car_model_colors AS cec')
            ->usingJoin('car_colors AS cc', 'colorId')
            ->select('cc.colorId AS color_id, cc.colorName AS name, cc.colorCode AS code, cec.fileId')
            ->where('cec.type', 'bcolors')
            ->where('cec.modelId', $modelId)
            ->orderBy('cec.orderBy ASC')->getAll('array');
        return $this->getColorImages($images);
    }
    /** Цвет салона у комплектации */
    private function getModelIColors($modelId): array
    {
        $images = connect('car_model_colors AS cec')
            ->usingJoin('car_colors AS cc', 'colorId')
            ->select('cc.colorId AS color_id, cc.colorName AS name, cc.colorCode AS code, cec.fileId')
            ->where('cec.type', 'icolors')->where('cec.modelId', $modelId)
            ->orderBy('cec.orderBy ASC')->getAll('array');
        return $this->getColorImages($images);
    }

    private function getColorImages($images): array
    {
        return collect($images)->map(function ($item) {
            if ($file = connect('files')->where('fileId', $item['fileId'])->get('array')) {
                $image = ImageCollection::init()->get($item, $file);
                unset($image['large'], $image['medium'], $image['small'], $item['fileId']);
                $item['image'] = $image['original'];
            }
            return $item;
        })->all();
    }

    /** получить все из таблицы images модели  */
    public function getFiles($table, $primaryKey, $id): ?array
    {
        $files = [];
        if ($images = connect($table . ' AS i')->leftJoin('files AS f','f.fileId', '=', 'i.fileId')
            ->select('i.fileId, i.type, i.position, f.directory, f.path, f.fileName, f.size')->where($primaryKey, $id)->orderBy('orderBy ASC')->getAll('array')) {
            collect($images)->map(function ($item) use (&$files) {
                if ($item['type'] == 'general') {
                    $files['general'] = ImageCollection::init()->get($item, $item);
                } elseif ($item['type'] == 'gallery') {
                    $files['gallery'][] = ImageCollection::init()->get($item, $item);
                } else {
                    $files['docs'][] = ImageCollection::init()->get($item, $item);
                }


                return $files;
            })->toArray();
        }

        return $files;
    }

//    public function getFilesOLD($table, $primaryKey, $id): ?array
//    {
//        $files = [];
//        if ($images = connect($table)->where($primaryKey, $id)->select('fileId, type, position')->orderBy('orderBy ASC')->getAll('array')) {
//            collect($images)->map(function ($item) use (&$files) {
//                if ($file = $this->getFileInfo($item['fileId'])) {
//                    if ($item['type'] == 'general') {
//                        $files['general'] = ImageCollection::init()->get($item, $file);
//                    } elseif ($item['type'] == 'gallery') {
//                        $files['gallery'][] = ImageCollection::init()->get($item, $file);
//                    } else {
//                        $files['docs'][] = ImageCollection::init()->get($item, $file);
//                    }
//                }
//
//                return $files;
//            })->toArray();
//        }
//
//        return $files;
//    }


    /** РАБОТА С ПАРМЕТРАМИ */

    /** Получить минимальную цену */
    public function getMinPriceEquipments($modelId)
    {
        return connect('car_equipments')->min('price', 'min_price')->where('status', 'V')->where('modelId', $modelId)->getValue();
    }

    /** Получить двигатель */
    public function engineName($code)
    {
        return connect('car_engine')->select('name')->where('code', $code)->getValue();
    }

    /** Получить трансмиссию */
    public function transmissionName($code)
    {
        return connect('car_transmission')->select('name')->where('code', $code)->getValue();
    }

    /** Получить привод*/
    public function gearName($code)
    {
        return connect('car_gear')->select('name')->where('code', $code)->getValue('array');
    }

}