<?php


namespace Mnv\Modules\Cars;

/**
 * Class Dealers
 * @package Mnv\Modules\Cars
 */
class Dealers
{

    /** @var string */
    protected string $table = 'dealers';

    /** @var string  */
    protected string $table_image = 'dealer_images';

    /** @var string  */
    protected string $primaryKey = 'dealerId';

    /** @var string  */
    protected string $orderBy = 'publishedOn DESC';

    protected string $columns = 'dealerId, publishedOn, title, coordinates, address, office_hours, phone, landmark, website';

    /** @var array  */
    public $dealers = [];

    /** @var int */
    private $section;

    public function all()
    {
        $this->dealers['type'] = "FeatureCollection";

        $dealers = connect($this->table)->select($this->columns)->orderBy($this->orderBy)->limit(1000)->getAll('array');

        foreach ($dealers as $dealerId => $dealer) {
            if (!empty($dealer['coordinates'])) {
                $this->dealers['features'][$dealerId]['id'] = $dealer['dealerId'];
                $this->dealers['features'][$dealerId]['type'] = "Feature";
                $this->dealers['features'][$dealerId]['geometry']['type'] = "Point";
                $this->dealers['features'][$dealerId]['geometry']['coordinates'] = explode(", ", $dealer['coordinates']);
                $this->dealers['features'][$dealerId]['properties']['balloonContent'] = $dealer['title'];
                $this->dealers['features'][$dealerId]['properties']['id'] = $dealer['dealerId'];
            }
        }
    }
}