<?php


namespace Mnv\Modules\Cars;


use Mnv\Core\Uploads\ImageCollection;

/**
 * Class Model
 * @package Mnv\Modules\Cars
 */
class EquipmentPage
{
    /** @var int */
    private int $modelId;
    /** @var array  */
    public array $model = [];

    public function __construct($modelId)
    {
        $this->modelId = $modelId;
    }


    public function getModifications(): EquipmentPage
    {
//        $modifications = connect('car_modifications')->select('name, power, modificationId')->where('status', 'V')->where('modelId', $this->modelId)->orderBy('orderBy ASC')->getAll('array');
        $modifications = connect('car_modifications')->select('name, power, engine, transmissions, gear')->where('status', 'V')->where('modelId', $this->modelId)->orderBy('orderBy ASC')->getAll('array');
        $modification = collect($modifications)->map(function ($modification) {

//            $modification['gear_name'] = $this->gearTypeName($modification['gear']);
//            $modification['specifications'] = $this->getSpecifications($modification['modificationId']);

            return $modification;
        })->all();
        $this->model['modifications'] = $modification;

        $this->model['gear_types'] = $this->gearTypes();
        return $this;
    }

    public function pdf(): EquipmentPage
    {
        if ($doc = connect('car_model_images')
            ->where('modelId', $this->modelId)->select('fileId')
            ->where('type', 'docs')
            ->orderBy('orderBy ASC')->get('array')) {

            $file = connect('files')->where('fileId', $doc['fileId'])->get('array');
            $this->model['pdf'] = ImageCollection::init()->get($doc, $file);
        }

        return $this;
    }

    /**
     * Получить комплектации по модели
     */
    public function getEquipments(): EquipmentPage
    {
        $equipments = connect('car_equipments')->select('title, price, oldPrice, equipmentId, modificationId')->where('status', 'V')->where('modelId', $this->modelId)->orderBy('publishedOn ASC')->getAll('array');
        $equipments =  collect($equipments)->map(function ($item) {
            $item['modification']    = connect('car_modifications')->select('modificationId, name, power, engine, transmissions, gear')->where('modificationId', $item['modificationId'])->get('array');
//            $item['modification']['gear_name'] = $this->gearTypeName($item['modification']['gear']);
            $item['options']  = $this->getOptionIds($item['equipmentId']);

            return $item;
        })->all();

        $this->model['equipments'] = $equipments;


        return $this;
    }
    public function gearTypes()
    {
        $gear_types = array();
        if (!empty($this->model['modifications'])) {
            collect($this->model['modifications'])->map(function ($modification) use (&$gear_types) {
                if (!isset($gear_types[$modification['gear']])) {
                    $gear_types[$modification['gear']] = $modification['gear'];
                }
            })->all();

            return connect('car_gear')->select('gearId, code, name')->in('code', $gear_types)->orderBy('gearId ASC')->getAll('array');
        }

        return array();
    }

    public function standardOptions(): EquipmentPage
    {
        $standards = connect('car_options')->select('optionId, name')->orderBy('orderBy ASC')->where('status', 'V')->whereNull('parentId',  false)->getAll('array');
        $values = array();
        collect($standards)->map(function ($option) use (&$values) {
            $values[$option['optionId']]['optionId'] = $option['optionId'];
            $values[$option['optionId']]['name'] = $option['name'];
            $options = connect('car_options')->select('optionId, name, hardware')->where('parentId', $option['optionId'])->where('status', 'V')->where('hardware', 'S')->whereNull('parentId', true)->orderBy('orderBy ASC')->getAll('array');
            $items = array();
            if (!empty($options)) {
                $items = collect($options)->map(function ($item) {
                    return $item['optionId'] = $item['name'];
//                    $items[$item['optionId']] = $item['name'];

                })->all();

            }
            $values[$option['optionId']]['options']  = $items;
        })->all();

        $this->model['standard_options'] = $values;

        return $this;
    }

    public function options(): EquipmentPage
    {
        $values = array();
        $standards = connect('car_options AS co')->leftJoin('car_option_models AS com', 'com.optionId', '=', 'co.optionId')
            ->select('co.optionId, co.name')->where('com.modelId', $this->modelId)->whereNull('co.parentId',  false)->orderBy('co.orderBy ASC')->getAll('array');

//        $standards = connect('car_options')->select('optionId, name')->orderBy('orderBy ASC')->where('status', 'V')->whereNull('parentId',  false)->getAll('array');
        collect($standards)->map(function ($option) use (&$values) {
            $values[$option['optionId']]['optionId'] = $option['optionId'];
            $values[$option['optionId']]['name'] = $option['name'];
            $items = array();
            if ($options = connect('car_options')->select('optionId, name')->where('parentId', $option['optionId'])->where('status', 'V')->whereNull('parentId', true)->orderBy('orderBy ASC')->getAll('array')) {
                collect($options)->map(function ($item) use (&$items) {
                    $items[$item['optionId']] = $item['name'];
                })->all();

            }
            if (!empty($items)) {
                $values[$option['optionId']]['property'] = $items;
            } else {
                unset($values[$option['optionId']]);
            }

        })->all();


        $this->model['options'] = $values;

        return $this;
    }

    /** Опции комплектации */
    private function getOptionIds(int $equipmentId): array
    {
        $optionList = array();
        if ($options = connect('car_options_value')->select('optionId')->where('equipmentId', $equipmentId)->getAll('array')) {
            collect($options)->map(function ($option) use (&$optionList) {
                $optionList[$option['optionId']] = $option['optionId'];
            })->all();
        }

        return $optionList;
    }


    /** Цвет кузова */
    public function getModelBColors(): EquipmentPage
    {
        $color = connect()->table('car_model_colors AS cec')->usingJoin('car_colors AS cc', 'colorId')->select('cc.colorName AS name, cc.colorCode AS code, cec.fileId, cec.price, cec.menu')
            ->where('cec.type', 'bcolors')->where('cec.menu', 'Y')
            ->where('cec.modelId', $this->modelId)->orderBy('cec.orderBy ASC')->get('array');

        if ($file = getFileInfo($color['fileId'])) {
            $color = ImageCollection::init()->get(null, $file);
        }
        $this->model['image'] = $color;

        return $this;
    }






//    /**
//     * Спецификация
//     * @param $modificationId
//     * @return array|null
//     */
//    public function getSpecifications($modificationId): ?array
//    {
//        $specifications = connect('car_specifications')->select('specificationId AS ID, name')->orderBy('orderBy')->whereNull('parentId',  false)->getAll('array');
//
//        return collect($specifications)->map(function ($specification) use ($modificationId) {
//            $properties = connect('car_specifications')->select('specificationId AS ID, parentId, name')->where('parentId', $specification['ID'])->whereNull('parentId',  true)->orderBy('orderBy ASC')->getAll('array');
//
//            $values = [];
//            collect($properties)->map(function ($item) use (&$values, $modificationId) {
//                $property = connect()->table('car_specifications_value')->select('value, unit')->where('specificationId', $item['ID'])->where('modificationId', $modificationId)->get('array');
//                if (!empty($property['value'])) {
//                    $values[$item['name']] = $property['value'];
//                }
//            })->all();
//
//            $specification['properties'] = $values;
//
//            return $specification;
//        })->all();
//    }
//


    /** РАБОТА С ФАЙЛАМИ / ИЗОБРАЖЕНИЕМ */

    protected function getFileInfo($fileId): ?array
    {
        return connect('files')->where('fileId', $fileId)->get('array');
    }

    /** получить все из таблицы images модели  */
    public function getFiles($table, $primaryKey, $sectionId): ?array
    {
        $files = [];
        if ($images = connect($table)->where($primaryKey, $sectionId)->select('fileId, type, position')->orderBy('orderBy ASC')->getAll('array')) {
            collect($images)->map(function ($item) use (&$files) {
                if ($file = $this->getFileInfo($item['fileId'])) {
                    if ($item['type'] == 'general') {
                        $files['general'] = ImageCollection::init()->get($item, $file);
                    } elseif ($item['type'] == 'gallery') {
                        $files['gallery'][] = ImageCollection::init()->get($item, $file);
                    } else {
                        $files['docs'][] = ImageCollection::init()->get($item, $file);
                    }
                }

                return $files;
            })->toArray();
        }

        return $files;
    }


    public static function getMinPriceEquipments($modelId)
    {
        return connect('car_equipments')->select('price')->where('status', 'V')->where('modelId', $modelId)->min('price', 'min_price')->getValue();
    }

//    public function gearTypeName($gear)
//    {
//        return connect('car_gear')->select('name')->where('code', $gear)->getValue();
//    }

}