<?php

namespace Mnv\Modules\Cars;

use Mnv\Core\Uploads\ImageCollection;

/**
 * Class Models
 * @package Mnv\Modules\Cars
 */
class Models
{
    private $fields = 'sectionId AS ID, name, alias AS name, url';

    public $model;
    public $models;

    /**
     * @param string $isType E = equipments / M = modifications
     */
    public function all($sectionIds = null, string $displayType = 'E')
    {
        $sections = connect('sections')->select($this->fields)->where('status', 'V')->where('typeContent', 'models')->in('sectionId', $sectionIds)->orderBy('sectionId ASC')->getAll('array');
        $models = collect($sections)->map(function ($section) use ($displayType) {
            $section['images'] = $this->getFiles('section_images', 'sectionId', $section['ID']);

            $types = connect('sections')->select('sectionId AS typeID, name AS typeName, url')->where('status', 'V')->where('typeContent', 'models')->where('parentId', $section['ID'])->orderBy('sectionId ASC')->getAll('array');
            $section['types'] = collect($types)->map(function ($type, $index) use ($displayType) {
                $type['images'] = $this->getFiles('section_images', 'sectionId', $type['typeID']);
                /** комплектации */
                $type['models'] = $this->getModelsNew($type['typeID'], $displayType);

                return $type;
            })->all();

            return $section;
        })->all();

        $this->models = $models;
    }

    /**
     * @param $sectionId
     * @param string $type E = equipments / M = modifications
     * @return array|mixed
     */
    public function getModelsNew($sectionId, string $type)
    {
        $models = connect('car_models')->select('title, modelId, typeId, fileName, url')->where('status', 'V')->where('sectionId', $sectionId)->getAll('array');
        return collect($models)->map(function ($model) use ($type) {
//          $model['exterior_colors'] = $this->getModeBColors($model['modelId']);
//          $model['interior_colors'] = $this->getModeIColors($model['modelId']);
//            $newModel['models'][$index]   = $model;
            $model['images'] = $this->getFiles('car_model_images', 'modelId', $model['modelId']);

            if ($type == 'E') {
                $model['equipments'] = $this->getModelEquipments($model['modelId']);
            } else if  ($type == 'M') {
                $model['modifications'] = $this->getModifications($model['modelId']);
            }

            return $model;
        })->all();
    }


    public function getModifications($modelId): array
    {
        $modifications = connect('car_modifications')->select('name, power, modelId, modificationId')->where('status', 'V')->where('modelId', $modelId)->orderBy('orderBy ASC')->getAll('array');
        return collect($modifications)->map(function ($modification) {
            $modification['equipments']     = $this->getModificationEquipments($modification['modificationId']);
            $modification['specifications'] = $this->getSpecifications($modification['modificationId']);

            return $modification;
        })->all();

    }
    public function getModificationEquipments($modificationId): array
    {
        if (!empty($modificationId)) {
            $equipments = connect('car_equipments')->select('title AS name, price, oldPrice, equipmentId')->where('status', 'V')->where('modificationId', $modificationId)->orderBy('orderBy ASC')->getAll('array');
            return collect($equipments)->map(function ($item) {
                $item['images'] = $this->getFiles('car_equipment_images', 'equipmentId', $item['equipmentId']);
                $item['options'] = $this->getOptions($item['equipmentId']);
                $item['exterior_colors'] = $this->getEquipmentBColors($item['equipmentId']);
                $item['interior_colors'] = $this->getEquipmentIColors($item['equipmentId']);


                return $item;
            })->all();
        }
    }

    /**
     * Получить комплектации по модели
     * @param $modelId
     * @return array
     */
    public function getModelEquipments($modelId): array
    {
        $equipments = connect('car_equipments')->select('title, price, oldPrice, equipmentId, modelId, sectionId')->where('status', 'V')->where('modelId', $modelId)->orderBy('orderBy ASC')->getAll('array');
        return collect($equipments)->map(function ($item) {
            $item['options'] = $this->getOptions($item['equipmentId']);
            $item['exterior_colors'] = $this->getEquipmentBColors($item['equipmentId']);
            $item['interior_colors'] = $this->getEquipmentIColors($item['equipmentId']);


            return $item;
        })->all();
    }


    /**
     * Спецификация
     * @param $modificationId
     * @return array|null
     */
    public function getSpecifications($modificationId): ?array
    {
        $specifications = connect('car_specifications')->select('specificationId AS ID, name')->orderBy('orderBy')->whereNull('parentId',  false)->getAll('array');

        return collect($specifications)->map(function ($specification) use ($modificationId) {
            $properties = connect('car_specifications')->select('specificationId AS ID, parentId, name')->where('parentId', $specification['ID'])->whereNull('parentId',  true)->orderBy('orderBy ASC')->getAll('array');

            $values = [];
            collect($properties)->map(function ($item, $index) use (&$values, $modificationId) {
                $property = connect()->table('car_specifications_value')->select('value, unit')->where('specificationId', $item['ID'])->where('modificationId', $modificationId)->get('array');
                if (!empty($property['value'])) {
                    $property['name'] = $item['name'];
                    $values[] = $property;
//                    $values['value'] = $property['value'];
//                    $values[$index]['value'] = $property['value'];
                }
            })->all();

            $specification['properties'] = $values;

            return $specification;
        })->all();
    }


    /**
     * Опции комплектации
     * @param $equipmentId
     * @return array
     */
    private function getOptions($equipmentId): array
    {
        $values = [];
        $options = connect('car_options')->select('optionId, name')->orderBy('orderBy ASC')->whereNull('parentId',  false)->indexKey('name')->getAll('array');
        foreach ($options as $optionId => $option) {
            $values = connect('car_options_value')->usingJoin('car_options AS ceo', 'optionId')->select('ceo.name')->where('ceo.parentId', $option['optionId'])->where('equipmentId', $equipmentId)->whereNull('ceo.parentId',  true)->getAll('array');
            foreach ($values as $valueId => $value) {
                $options[$optionId]['properties'][$valueId] = $value['name'];
            }
            unset($options[$optionId]['optionId']);
        }

        return $options;
    }

    /** Цвет кузова у модели */
    private function getModeBColors($modelId)
    {
        $colors = connect()->table('car_model_colors AS cec')->usingJoin('car_colors AS cc', 'colorId')->select('cc.colorName AS name, cc.colorCode AS code, cec.fileId, cec.price')->where('cec.type', 'bcolors')->where('cec.modelId', $modelId)->orderBy('cec.orderBy ASC')->getAll('array');
        return collect($colors)->map(function ($color) {
            if ($file = getFileInfo($color['fileId'])) {
                $color['general'] = ImageCollection::init()->get(null, $file);
            }

            return $color;
        })->all();
    }
    /** Цвет салона  у модели */
    private function getModeIColors($modelId)
    {
        $colors = connect()->table('car_model_colors AS cec')->usingJoin('car_colors AS cc', 'colorId')->select('cc.colorName AS name, cc.colorCode AS code, cec.fileId, cec.price')->where('cec.type', 'icolors')->where('cec.modelId', $modelId)->orderBy('cec.orderBy ASC')->getAll('array');
        return collect($colors)->map(function ($color) {
            if ($file = getFileInfo($color['fileId'])) {
                $color['general'] = ImageCollection::init()->get(null, $file);
            }

            return $color;
        })->all();
    }

    /** Цвет кузова у комплектации */
    private function getEquipmentBColors($equipmentId)
    {
        $images = connect()->table('car_equipment_colors AS cec')->usingJoin('car_colors AS cc', 'colorId')->select('cc.colorName AS name, cc.colorCode AS code, cec.fileId, cec.price')->where('cec.type', 'bcolors')->where('cec.equipmentId', $equipmentId)->orderBy('cec.orderBy ASC')->getAll('array');
        return collect($images)->map(function ($item)  {
            if ($file = $this->getFileInfo($item['fileId'])) {
                $item = ImageCollection::init()->get($item, $file);
            }
            return $item;
        })->all();
    }
    /** Цвет салона у комплектации */
    private function getEquipmentIColors($equipmentId)
    {
        $images = connect()->table('car_equipment_colors AS cec')->usingJoin('car_colors AS cc', 'colorId')->select('cc.colorName AS name, cc.colorCode AS code, cec.fileId, cec.price')->where('cec.type', 'icolors')->where('cec.equipmentId', $equipmentId)->orderBy('cec.orderBy ASC')->getAll('array');
        return collect($images)->map(function ($item) {
            if ($file = $this->getFileInfo($item['fileId'])) {
                $item = ImageCollection::init()->get($item, $file);
            }
            return $item;
        })->all();
    }



    /** РАБОТА С ФАЙЛАМИ / ИЗОБРАЖЕНИЕМ */

    protected function getFileInfo($fileId): ?array
    {
        return connect('files')->where('fileId', $fileId)->get('array');
    }

    /** получить все из таблицы images модели  */
    public function getFiles($table, $primaryKey, $sectionId): ?array
    {
        $files = [];
        if ($images = connect($table)->where($primaryKey, $sectionId)->select('fileId, type, position')->orderBy('orderBy ASC')->getAll('array')) {
            collect($images)->map(function ($item) use (&$files) {
                if ($file = $this->getFileInfo($item['fileId'])) {
                    if ($item['type'] == 'general') {
                        $files['general'] = ImageCollection::init()->get($item, $file);
                    } elseif ($item['type'] == 'gallery') {
                        $files['gallery'][] = ImageCollection::init()->get($item, $file);
                    }
                    else {
                        $files['docs'][] = ImageCollection::init()->get($item, $file);
                    }
                }

                return $files;
            })->toArray();
        }

        return $files;
    }

}