<?php


namespace Mnv\Modules;


use Mnv\Core\Utilities\Cookie\Cookie;

class Discount
{
    private $isDiscount = false;

    /**
     * Конструктор класса
     */
    public function __construct()
    {
        $this->load();
    }

    /**
     * Добавление/удаление новости в закладки
     * @param bool $isDiscount
     */
    public function set(bool $isDiscount = false)
    {
        Cookie::setcookie('_discount', $isDiscount, \time() + 3600 * 24 * 1000, "/");
    }

    /**
     * Получение списка закладок
     * @return void
     */
    private function load()
    {
        $this->isDiscount = Cookie::get('_discount');
    }
}