<?php

use Mnv\Core\ConfigManager,
    Mnv\Core\Design,
    Mnv\Core\Maps,
    Mnv\Core\Locale\I18N,
    Mnv\Core\Utilities\Url;

const LS_VERSION    = '11.03.11';
const LS_SERIAL     = '+998 (90) 345-11-33';
const PRODUCT_NAME  = 'LS PANEL (https://www.life-style.uz/)';

/** Checking the PHP version on your server */
if (PHP_VERSION_ID < 70400) {
    echo '<script>alert("Attention! LS PANEL requires PHP version 7.4 or higher to function properly. Please update the PHP version on your server to ensure full access to all panel features.");</script>';
    die();
}

/** Autoloader */
require_once 'composer/vendor/autoload.php';

define('GLOBAL_ROOT', realpath(dirname(__FILE__) . '/../'));
define('REQUESTED_FILE', substr(strrchr($_SERVER['REQUEST_URI'], '/'), 1));
define('FS_READ_MODE', 'fopen');
define('UPLOAD_ROOT', GLOBAL_ROOT . '/uploads/');
define('ERRORS_LOG', GLOBAL_ROOT . "/temp/log/");
define('IS_HTTPS', Url::is_https());

/** загрузить все языки */
$LANGUAGES = include GLOBAL_ROOT . '/includes/global-languages.inc.php';
/** определить язык */
define('SITE_LANG', isset($_GET['SITE_LANG'], $LANGUAGES[$_GET['SITE_LANG']]) ? $_GET['SITE_LANG'] : '');

if (!empty(SITE_LANG)) {
    define('SITE_LANG_PATH', '/' . SITE_LANG);
    define('SITE_LANG_PREFIX', SITE_LANG . '_');
    define('SITE_LANG_POSTFIX', '-' . SITE_LANG);
    define('SITE_ROOT', GLOBAL_ROOT . SITE_LANG_PATH);
} else {
    define('SITE_LANG_PATH', '');
    define('SITE_LANG_PREFIX', '');
    define('SITE_LANG_POSTFIX', '');
    define('SITE_ROOT', GLOBAL_ROOT);
}

define("GLOBAL_URL", (IS_HTTPS ? 'https://' : 'http://') . $_SERVER['HTTP_HOST']);
const GLOBAL_URI    = '';
const SITE_URL      = GLOBAL_URL . SITE_LANG_PATH;
const UPLOAD_URL    = GLOBAL_URL . SITE_LANG_PATH . '/uploads';
const SITE_URI      = '/' . SITE_LANG_PATH;

if (SITE_LANG !== '' && $LANGUAGES[SITE_LANG]['isDefault'] === 1) {
    redirect(GLOBAL_URL);
    die('Redirecting to ' . GLOBAL_URL);
}
const ASSETS_URL    = GLOBAL_URL . '/themes/assets';

$gmNow = gmdate('Y-m-d H:i:s');
/** типы визитов */
$allVisitTypes[1]['name'] = 'Home';
$allVisitTypes[2]['name'] = 'Section';
$allVisitTypes[3]['name'] = 'Article';
$allVisitTypes[4]['name'] = 'Search';
$allVisitTypes[5]['name'] = 'AdClick';
$allVisitTypes[6]['name'] = 'Error';
$allVisitTypes[7]['name'] = 'RSS';
$allVisitTypes[8]['name'] = 'Sitemap';
$allVisitTypes[9]['name'] = 'Product';

/** Script Execution Timing */
[$uSec, $sec] = explode(' ', microtime());
$scriptStartTime = ((float)$uSec + (float)$sec);

/** Enable Error Reporting */
error_reporting(E_ALL);
ini_set('display_errors', 'stdout');

/** Include Components */
require GLOBAL_ROOT . '/includes/config.inc.php';
require_once GLOBAL_ROOT . '/includes/helpers.inc.php';
require_once GLOBAL_ROOT . '/includes/functions.inc.php';
require_once GLOBAL_ROOT . '/includes/db.table.inc.php';

/** Initialization */
$config = ConfigManager::init()->config();
$maps = Maps::init()->getMapValues();
$smarty = Design::init()->design();


/** Language Code Setup (ru, uz, en) */
I18N::set(ConfigManager::getValue('website_language'));

/** Theme Paths */
define('THEME_URL', GLOBAL_URL . '/themes/' . ConfigManager::getValue('theme'));
define('THEME_ROOT', GLOBAL_ROOT . '/themes/' . ConfigManager::getValue('theme'));


/** определение пути до темы */
//define('THEME_URL', (empty($THEME_URL) || IS_HTTPS) ? GLOBAL_URL . '/themes/' . ConfigManager::getValue('theme') : $THEME_URL);
//define('THEME_ROOT', (empty($THEME_ROOT) || IS_HTTPS) ? GLOBAL_ROOT.'/themes/'. ConfigManager::getValue('theme') : $THEME_ROOT);

/** назначение основных переменных */
/** Assign Smarty Variables */
$smarty->assign([
    'config'        => $config,
    'maps'          => $maps,
    'SITE_URL'      => SITE_URL,
    'SITE_URI'      => SITE_URI,
    'SITE_LANG'     => SITE_LANG,
    'THEME_URL'     => THEME_URL,
    'ASSETS_URL'    => ASSETS_URL,
    'GLOBAL_URL'    => GLOBAL_URL,
    'GLOBAL_URI'    => '',
    'UPLOAD_URL'    => UPLOAD_URL,
    'IS_HTTPS'      => IS_HTTPS,
//    'LANG'          => siteLanguage(ConfigManager::getValue('website_language')),
    'DEVELOPER'     => Mnv\Models\UserGroups::DEVELOPER,
]);

//$smarty->assignByRef('LANGUAGES', $LANGUAGES);
$smarty->assignByRef('TREE', $TREE);
$smarty->assignByRef('SECTIONS', $SECTIONS);
$smarty->assignByRef('CURRENCIES', $CURRENCIES);
$smarty->default_modifiers = ['escape'];

/** загрузка системных настроек, сериализация */
if (file_exists(SITE_ROOT . '/includes/serializations.inc.php')) {
    include str_replace("//", "/", SITE_ROOT) . '/includes/serializations.inc.php';
}

/** Set Headers */
header('Content-Type: text/html; charset=' . ConfigManager::getValue('charset'));
header('X-Powered-By: ' . PRODUCT_NAME . ' - ' . LS_SERIAL);

/** Enforce HTTPS if Required */
if (ConfigManager::getValue('only_ssl') && !IS_HTTPS) {
    if (!empty($_SERVER['HTTP_HOST']) && !empty($_SERVER['REQUEST_URI'])) {
        $_SERVER['REQUEST_URI'] = htmlspecialchars($_SERVER['REQUEST_URI'], ENT_QUOTES, ConfigManager::getValue('charset'));
        header("HTTP/1.0 301 Moved Permanently");
        header("Location: https://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
        die("Redirecting...");
    }
}

/** Disable Passing Session IDs via URL */
@ini_set('session.use_trans_sid', 0);
@ini_set('session.use_only_cookies', 1);

/** Enable GZIP Compression */
@ob_start('ob_gzhandler');

/** Include Overall Script */
require_once 'overall.pub.inc.php';
//print_r($smarty);
//print_r($LANGUAGES);