<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

function smarty_function_fetch_model_equipments($params, &$smarty)
{
    global $fetchedEquipments;

	$assign        = fetch_getParam('assign', $params, 'equipments');
//	$fields        = fetch_getParam('fields', $params, 'equipmentId, modelId, modificationId, title, summary, content, orderBy');
	$fields        = fetch_getParam('fields', $params, 'equipmentId, modelId, modificationId, title, price, oldPrice, monthPay, inStock');
	$status        = fetch_getParam('status', $params, 'V');
    $limit         = (int) fetch_getParam('limit', $params);
    $perPage       = (int) fetch_getParam('perPage', $params, $limit);
    $page          = (int) fetch_getParam('page', $params);

    $skip          = fetch_getParam('skip', $params, NULL);
    $noSubsections = (boolean) fetch_getParam('noSubsections', $params, false);
    $brands        = fetch_getParam('brands', $params, '');
    $minPrice 		= (int) fetch_getParam('minPrice', $params, 0);
    $maxPrice 		= (int) fetch_getParam('maxPrice', $params, 0);

	$query         = fetch_getParam('query', $params, NULL);
	$match         = fetch_getParam('match', $params, 'any');
	$order         = fetch_getParam('order', $params, NULL);
	$orderBy       = fetch_getParam('orderBy', $params, $order);


    $assignPagination = fetch_getParam('assignPagination', $params);
    $path             = fetch_getParam('path', $params);
    $seFriendly       = (boolean) fetch_getParam('seFriendly', $params);
    $pnFirst          = (int) fetch_getParam('pnFirst', $params, 0);
    $pnBefore         = (int) fetch_getParam('pnBefore', $params, 4);
    $pnAfter          = (int) fetch_getParam('pnAfter', $params, 4);
    $pnLast           = (int) fetch_getParam('pnLast', $params, 0);

    if ($page < 1) $page = 1;
    if ($perPage < 1) $perPage = 10;


    filterEquipments($status, $orderBy, $query, $minPrice, $maxPrice);

    /** query conditions */
    fetch_equipments_addQueryConditions($query, $match, $fields, $orderBy);
    /** add section conditions */
    fetch_equipments_addSectionConditions($brands, $noSubsections);
    /** skipping articles */
    fetch_equipments_addSkipConditions($skip);
    /** checking article fields */
    fetch_equipments_filterFields($fields);

	$equipments = connect('car_equipments')->select($fields)->pagination($perPage, $page)->keyBy('equipmentId');
    $equipments = prepareEquipments($equipments);
    $equipments = collect($equipments)->map(function ($equipment) {
        $equipment['model'] = connect('car_models AS cm')->leftJoin('sections AS s', 's.sectionId', '=', 'cm.sectionId')->select('cm.modelId, cm.sectionId, cm.title, s.name AS brand, cm.fileName, cm.url')->where('cm.modelId', $equipment['modelId'])->get('array');
        $equipment['modification'] = connect('car_modifications AS cm')
            ->leftJoin('car_gear AS cg', 'cg.code', '=', 'cm.gear')
            ->leftJoin('car_engine AS ce', 'ce.code', '=', 'cm.engine')
            ->select('cm.modificationId, cm.name, cm.power, cm.power_reserve, cm.battery_capacity, cm.acceleration, cm.engine, ce.name AS engineName, cm.transmission, cm.gear, cg.name AS gearName')
            ->where('modificationId', $equipment['modificationId'])
            ->get('array');

        return $equipment;
    })->all();


//print_r($equipments);

	$smarty->assign($assign, $equipments);

    /* saving fetched equipments for SKIP ability */
    if (empty($fetchedEquipments[$assign])) {
        $fetchedEquipments[$assign] = [];
    }

    if (!empty($equipments)) {
        foreach ($equipments as $equipment) {
            $fetchedEquipments[$assign][] = $equipment['equipmentId'];
        }
    }


    if (!empty($assignPagination)) {

        if (!is_null($query) && is_array($path)) $path[] = "query=".urlencode($query);

        filterEquipments($status, $orderBy, $query, $minPrice, $maxPrice);

        /** query conditions */
        fetch_equipments_addQueryConditions($query, $match, $fields, $orderBy);
        /** add section conditions */
        fetch_equipments_addSectionConditions($brands, $noSubsections);
        /** skipping articles */
        fetch_equipments_addSkipConditions($skip);
        /** checking article fields */
        fetch_equipments_filterFields($fields);

        /** page numbering */
        $total = connect('car_equipments')->countDistinct('equipmentId')->getValue();
        if (is_array($path)) {
            $path = SITE_URL.'/'.basename($_SERVER['PHP_SELF']).'?'.(!empty($path) ? implode('&', $path).'&' : '');
            $seFriendly = false;
        }
        $pagination = getPageNums($total, $page, $perPage, $pnFirst, $pnBefore, $pnAfter, $pnLast, $path, $seFriendly);
        $smarty->assign($assignPagination, $pagination);
    }

	return null;
}

function filterEquipments($status, $orderBy, $query, $minPrice, $maxPrice)
{
    $gmDate = gmdate('Y-m-d H:i:s');
    /** conditions */
    connect()->where('publishedOn','<=', $gmDate);


    if (!empty($status))    connect()->where('status', $status);
    if (!empty($maxPrice)) connect()->between('price', $minPrice, $maxPrice);


    if (empty($orderBy)) {
        connect()->orderBy(is_null($query) ? 'publishedOn DESC' : 'publishedOn DESC');
    } else {
        if ($orderBy == 'popularity') {
            connect()->orderBy('popularityLast7days DESC');
        } else if ($orderBy == 'asc') {
            connect()->orderBy('price ASC');
        } else if ($orderBy == 'desc') {
            connect()->orderBy('price DESC');
        } else if ($orderBy == 'rating') {
            connect()->orderBy('rating DESC');
        } else {
            connect()->orderBy($orderBy);
        }
    }
}

?>