<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

function smarty_function_fetch_sections($params, &$smarty) {
	global $SECTIONS;

	$assign     = fetch_getParam('assign', $params, 'sections');
	$fields     = fetch_getParam('fields', $params, 'sectionId, parentId, name, alias, url, content');
	$status     = fetch_getParam('status', $params, 'V');
	$from       = fetch_getParam('from', $params, NULL);
    $sections   = fetch_getParam('sections', $params, NULL);
    $parents    = fetch_getParam('parents', $params, NULL);
	$level      = (int) fetch_getParam('level', $params, 0);
	$type       = fetch_getParam('type', $params, '');
	$limit      = (int) fetch_getParam('limit', $params);
    $headerMenu = (int) fetch_getParam('headerMenu', $params);
    $footerMenu = (int) fetch_getParam('footerMenu', $params);

    $isBlock = fetch_getParam('isBlock', $params, NULL);


    $getContent = (bool) fetch_getParam('getContent', $params, false);
    $getImage   = (bool) fetch_getParam('getImage', $params, false);
    $imageType  = fetch_getParam('imageType', $params, 'general');

	if (empty($assign)) {
		$smarty->_trigger_fatal_error('fetch_sections: "assign" must not be empty');
		return;
	}

    $total = 0;
    $result = [];
    $sectionIds = [];
    $parentIds = [];

	if (!is_null($sections)) {
        $sectionIds = is_array($sections) ? $sections : array_map('trim', explode(',', $sections));

		foreach ($SECTIONS as $sectionId => $section) {
			if (($key = array_search($section['dir'], $sectionIds, true))
                || ($key = array_search($section['fileName'], $sectionIds, true))
                || ($key = array_search($section['sectionId'], $sectionIds, true))) {
				$sectionIds[$key] = $section['sectionId'];
			}
		}

		foreach ($sectionIds as $key => $sectionId) {
            $result[$sectionId] = $key;
        }
	}

    /** получение всех подразделов при массиве parents */
    if (!is_null($parents)) {
        $parents = is_array($parents) ? $parents : array_map('trim', explode(',', $parents));
        foreach ($SECTIONS as $section) {
            if (in_array($section['sectionId'], $parents, true)) {
                $parentIds = array_merge($parentIds, $section['children'] ?? []);
            }
        }
//        foreach ($SECTIONS as $section) {
//            if (in_array($section['sectionId'], $parents, true)) {
//                $parentIds[] = $section['children'];
//            }
//        }
//        $parentIds = array_merge([], ...$parentIds);

        foreach ($parentIds as $key => $sectionId) {
            $result[$sectionId] = $key;
        }
    }


    /** получение всех подразделов */
    if (!is_null($from)) {
        $parentId = is_numeric($from) ? (int)$from : array_search($from, array_column($SECTIONS, 'dir'), true);
    }

//	if (!is_null($from)) {
//		if (is_numeric($from) && (($from == 0) || !empty($SECTIONS[$from]))) {
//			$parentId = $from;
//		} else {
//			foreach ($SECTIONS as $sectionId => $section) {
//				if ($section['dir'] == $from) {
//					$parentId = $sectionId;
//					break;
//				}
//			}
//		}
//	}

	foreach ($SECTIONS as $sectionId => $section) {
		if (!empty($limit) && $total >= $limit) break;
		if (!empty($sectionIds) && !in_array($section['sectionId'], $sectionIds)) continue;
		if (!empty($parentIds) && !in_array($section['sectionId'], $parentIds)) continue;
		if (!empty($parentId) && $section['parentId'] != $parentId) continue;
		if (!empty($level) && $section['level']       != $level) continue;
		if (!empty($status) && $section['status']     != $status) continue;
        if (!empty($headerMenu) && $section['headerMenu'] != $headerMenu) continue;
        if (!empty($footerMenu) && $section['footerMenu'] != $footerMenu) continue;
        if (!is_null($isBlock) && $section['isBlock'] != $isBlock) continue;
		if (!empty($type) && $section['type']         != $type) continue;
		$result[$sectionId] = $section;
		$total++;
	}

    if (!empty($result)) {
        foreach ($result as $sectionId => $section) {
            if (empty($section['name'])) {
                unset($result[$sectionId]);
            }
        }
    }

    /** получение контента */
	if ($getContent && !empty($result)) {
        $contents = connect('sections')->select($fields)->in('sectionId', array_keys($result))->getAll('array');
        foreach ($contents as $item) {
            $result[$item['sectionId']]['content'] = $item['content'];
        }
	}

	/** получение картинки */
	if ($getImage && !empty($result)) {
	    $result = prepareSections($result, $imageType);
	}

//    print_r($result);
	$smarty->assign($assign, $result);
	

	return null;
}
