<?php

use Mnv\Core\ConfigManager;
use Mnv\Core\Utilities\Cookie\Session;

require_once '../includes/visitor.inc.php';

$time_start = microtime(true);

	$sectionId 	= (int) request()->get('sectionId');
	$page      	= (int) request()->get('page');
	$rewrite   	= request()->get('rewrite');
    $query      = request()->get('query');

    $brands     = request()->get('brands');
    $min        = request()->get('min');
    $max        = request()->get('max');

    if (!empty($SECTIONS[$sectionId])) {
		$section = prepareSection($SECTIONS[$sectionId]);
		$smarty->assign('section', $section);
	} else {
		header("HTTP/1.0 301 Moved Permanently");
		header("Location: ".SITE_URL."/");

		/* saving visit */
		writeErrorVisit(301);
		exit;
	}

	/* checking whether we in rewrite mode */
	if ($rewrite != ConfigManager::getValue('rewrite')) {
		header("HTTP/1.0 301 Moved Permanently");
        header("Location: $section[url]");

		/* saving visit */
		writeErrorVisit(301);
		exit;
	}

    $requestUri = $_SERVER["REQUEST_URI"];
    $countReplace = 0;
    $replaced_url = preg_replace('/\/\/+/', '/', $requestUri, -1, $countReplace);
    if ($countReplace > 0) {
        header("HTTP/1.0 301 Moved Permanently");
        header("Location: $section[url]");
        exit;
    }

	/* caching procedures */
	if ($section['isCached'] == 1) {
		$smarty->caching( 2, $section['cacheTime'] * $section['cachePeriod']);
	} elseif ($section['isCached'] != -1 && ConfigManager::getValue('cache_enabled_section') == 1) {
		$smarty->caching = 2;
        $smarty->caching( 2, ConfigManager::getValue('cache_time_section') * ConfigManager::getValue('cache_period_section'));
	}

	if ($page < 1) $page = 1;
    $smarty->assign('page', $page);

	/* for "you-are-here" navigation */
	$sectionParents = getSectionParents($sectionId);
	$section['parent'] = getSectionParent($section['parentId']);

	$smarty->assign('sectionParents', $sectionParents);
	$smarty->assign('activeSection', $SECTIONS[$sectionId]);


    $params = [];
    if (!empty($query)) $params['query'] = $query;
    if (!empty($brands)) $params['brands'] = $brands;
    if (!empty($min)) $params['min'] = $min;
    if (!empty($max)) $params['max'] = $max;

    $queryString = !empty($params) ? '&' . http_build_query(array_filter($params)) : '';
    $smarty->assign('queryString',  urldecode(preg_replace( '/^.(.*)$/', '\1', $queryString )));

    $smarty->assign('query', $query);

	/* saving visit */
	writeSectionVisit($sectionId, $page);

    $templateName = empty($section['templateName']) ? ($section['type'] == 'tree' ? 'section.tpl' : 'page.tpl') : $section['templateName'];
	$smarty->display($templateName, "$sectionId-$page".SITE_LANG_POSTFIX);

	/* precise load time */
	updateLoadTime();


// Отладочная информация
print "<!--\r\n";
$time_end = microtime(true);
$exec_time = $time_end-$time_start;
if(function_exists('memory_get_peak_usage')) {
    print "memory peak usage: ".memory_get_peak_usage()." bytes (" . (memory_get_peak_usage(true)/1024/1024)." MiB) \r\n";
    print "Memory in use: " . memory_get_usage() . " (". (sprintf("%0.2f",(memory_get_usage() / 1024) / 1024)) ."M) \r\n";
}
print "page generation time: " . $exec_time . " seconds\r\n";
print "php run time: ". round($exec_time, 4) . " seconds\r\n";
print "Query count: ".     connect()->queryCount() . "\r\n";
print "-->";

?>