export const catalog = () => {

    let minPrice,
        maxPrice;
    function _helperSumReplace(sum) {
        return Math.trunc(sum).toString().replace(/(\d)(?=(\d{3})+$)/g, '$1 ')
    }

    function _sumInFields(arg) {
        const { slider, first, second } = arg

        slider.noUiSlider.on('update', function (numericValue) {
            const firstSum = numericValue[0],
                secondSum = numericValue[1]

            minPrice = Number(firstSum)
            maxPrice = Number(secondSum)

                first.textContent = _helperSumReplace(firstSum)
            second.textContent = _helperSumReplace(secondSum)
        })
    }

    function priceSlider() {
        const sliderPriceNode = document.querySelector('.catalog-price_js')
        const priceFirst = document.querySelector('.catalog-price-first_js')
        const priceSecond = document.querySelector('.catalog-price-second_js')

        if (sliderPriceNode) {
            const sumMin = Number(sliderPriceNode.getAttribute('data-min'))
            const sumMax = Number(sliderPriceNode.getAttribute('data-max'))
            const sumCurrentMin = Number(sliderPriceNode.getAttribute('data-current-min'))
            const sumCurrentMax = Number(sliderPriceNode.getAttribute('data-current-max'))

            let currentMin = sumCurrentMin
            let currentMax = sumCurrentMax

            if (sumCurrentMin === 0 || !sumCurrentMin) {
                currentMin = sumMin
            }

            if (sumCurrentMax === 0 || !sumCurrentMax) {
                currentMax = sumMax
            }

            noUiSlider.create(sliderPriceNode, {
                start: [currentMin, currentMax],
                range: {
                    min: sumMin,
                    max: sumMax,
                },
                connect: true,
            })

            _sumInFields({
                slider: sliderPriceNode,
                first: priceFirst,
                second: priceSecond,
            })
        }
    }
    const applyFiltersButton = document.getElementById('applyFilters');
    if (applyFiltersButton) {
        applyFiltersButton.addEventListener('click', function () {

            const params = new URLSearchParams();

            // Бренды
            const selectedBrands = Array.from(document.querySelectorAll('.brand_filter:checked')).map(input => input.value);
            if (selectedBrands.length > 0) {
                params.append('brands', selectedBrands.join(','));
            }
            // Диапазон цен
            if (minPrice && maxPrice) {
                const sliderPriceNode = document.querySelector('.catalog-price_js')
                const sumMin = Number(sliderPriceNode.getAttribute('data-min'))
                const sumMax = Number(sliderPriceNode.getAttribute('data-max'))

                if (minPrice !== sumMin || maxPrice !== sumMax) {
                    params.append('min', minPrice);
                    params.append('max', maxPrice);
                }
            }

            // Построение URL
            const baseUrl = window.location.origin + window.location.pathname;
            // Перенаправление
            window.location.href = params.size ? `${baseUrl}?${params.toString()}` : baseUrl;
        });
    } else {
        console.log('Кнопка "Применить" не найдена.');
    }

    priceSlider()
}
