<!DOCTYPE html>
<html lang="{$config.website_language}" data-url="{$SITE_URL}">
<head>
	{include file="modules/meta.tpl"}
    {include file="modules/link.tpl"}
	{* recaptcha - ОБЯЗАТЕЛЬНО *}
	{include file="modules/recaptcha.tpl"}
	{* /recaptcha - ОБЯЗАТЕЛЬНО *}

	{* Код Яндекс.Метрики *}
	{yandex_statistics}

</head>

<body>

{fetch_sections assign=headerMenus status="V" headerMenu=1 level=1}

<div class="wrapper">

	<header class="header">
		<div class="flex:col-max">

			<div class="header__inner">

				{logo link=true classLink="header__logo"}

				<div class="header__part">

					<nav class="header__nav">
						<ul>
							{foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
								<li>
									{fetch_sections assign=headerSubMenus from=$headerMenu.sectionId status="V" headerMenu=1 level=2 getImage=true}
									{if $headerMenu.childLevels >= 1 && !empty($headerSubMenus)}
										<button>{$headerMenu.alias}</button>

										<div class="header__nav-drop">
											<div class="flex:col-max">
												<ul>
													{foreach item=headerSubMenu from=$headerSubMenus name=headerSubMenus}
														<li>
															<a class="header__card" href="{$SITE_URL}{$headerSubMenu.url}">
																<div class="header__card-img"><img src="{$headerSubMenu.image.large|default:"{$ASSETS_URL}/images/header/1.jpg"}" alt="{$headerSubMenu.name}"></div>
																<div class="header__card-desc">
																	<div class="text-tmp txt-fw-500 color-white all-center"><p>{$headerSubMenu.name}</p></div>
																</div>
															</a>
														</li>
													{/foreach}
												</ul>
											</div>
										</div>
									{else}
										<a {if isset($section.sectionId) && $section.sectionId eq $headerMenu.sectionId}class="active"{/if} href="{$SITE_URL}{$headerMenu.url}">{$headerMenu.alias}</a>
									{/if}
								</li>
							{/foreach}

						</ul>
					</nav>

					<div class="header__lang">
						<ul>
							<li>
								<button>РУ</button>
								<ul>
									<li><a href="{$GLOBAL_URL}/uz/">UZ</a></li>
									<li><a href="{$GLOBAL_URL}/ru/">RU</a></li>
								</ul>
							</li>
						</ul>
					</div>

					<button class="header__btn-call" data-modal-id="modal_call">Заказать звонок</button>

					<div class="social header__social">{include file="modules/socials.tpl"}</div>

					<button class="header__btn header-btn_js">
                    <span class="burger-btn burger-btn_cross-deg">
                        <span class="burger-btn__item"></span>
                    </span>
					</button>

				</div>

			</div>

		</div>

		<div class="header-mob header-mob_js">
			<div class="header-mob__inner">

				<div class="header-mob__head">
					<button class="header-mob__btn-close">
						<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#000">
							<path d="M256-227.69 227.69-256l224-224-224-224L256-732.31l224 224 224-224L732.31-704l-224 224 224 224L704-227.69l-224-224-224 224Z" />
						</svg>
					</button>

					{logo link=true classLink="header-mob__logo"}
				</div>

				<div class="header-mob__content">

					<div class="header-mob__nav">
						<ul>
							{foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
							<li>
								{fetch_sections assign=headerSubMenus from=$headerMenu.sectionId status="V" headerMenu=1 level=2}
								{if $headerMenu.childLevels >= 1 && !empty($headerSubMenus)}
									<button class="header-mob-btn_js">{$headerMenu.alias}</button>
								{else}
									<a {if isset($section.sectionId) && $section.sectionId eq $headerMenu.sectionId}class="active"{/if} href="{$SITE_URL}{$headerMenu.url}">{$headerMenu.alias}</a>
								{/if}
							</li>
							{/foreach}
						</ul>
					</div>

				</div>

				<div class="header-mob__footer">
					<div class="social">
						{include file="modules/socials.tpl"}
					</div>

					<div class="header-mob__contacts">
						<ul>
							<li>Для информации</li>
							{assign var=phones value=", "|explode:$config.phone}
							{foreach from=$phones item=phone name=phones}{if $smarty.foreach.phones.first}
								<li><a href="tel:{$phone|strip_phone}">{$phone|format_phone}</a></li>
							{/if}{/foreach}
						</ul>
					</div>

					<button class="btn accent-2 full" data-modal-id="modal_call">Заказать звонок</button>
				</div>

				<!--  -->
				<div class="header-mob__drops">
					{foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
						{fetch_sections assign=headerSubMenus from=$headerMenu.sectionId status="V" headerMenu=1 level=2 getImage=true}
						{if $headerMenu.childLevels >= 1 && !empty($headerSubMenus)}
							<div class="header-mob__drop header-mob-drop_js">
								<div class="header-mob__head">
									<button class="header-mob__btn-close">{include file="icon/svg.tpl" svgId="header_mob_btn_close" fill="none"}</button>
									<button class="header-mob__btn-back header-mob-btn-back_js">Назад</button>
								</div>

								<div class="header-mob__content">
									<div class="text-tmp txt-36 txt-fw-700"><p>{$headerMenu.alias}</p></div>

									<div class="header-mob__cards">
										{foreach item=headerSubMenu from=$headerSubMenus name=headerSubMenus}
											<a class="header__card" href="{$SITE_URL}{$headerSubMenu.url}">
												<div class="header__card-img"><img src="{$headerSubMenu.image.large|default:"{$ASSETS_URL}/images/header/1.jpg"}" alt="{$headerSubMenu.name}"></div>
												<div class="header__card-desc">
													<div class="text-tmp txt-fw-500 color-white all-center"><p>{$headerSubMenu.name}</p></div>
												</div>
											</a>
										{/foreach}
									</div>
								</div>

								<div class="header-mob__footer">
									<div class="social">{include file="modules/socials.tpl"}</div>
									<div class="header-mob__contacts">
										<ul>
											<li>Для информации</li>
											{assign var=phones value=", "|explode:$config.phone}
											{foreach from=$phones item=phone name=phones}{if $smarty.foreach.phones.first}
												<li><a href="tel:{$phone|strip_phone}">{$phone|format_phone}</a></li>
											{/if}{/foreach}
										</ul>
									</div>

									<button class="btn accent-2 full" data-modal-id="modal_call">Заказать звонок</button>
								</div>
							</div>
						{/if}
					{/foreach}
				</div>
			</div>
		</div>
	</header>