{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

<main class="main">

    {* Слайдер *}
    {*    {include file="modules/slider.tpl"}*}
    {* /Слайдер *}

    {* Марки *}
    {include file="blocks/brands.tpl" separation="2"}
    {* Марки *}

    {* Авто в наличии *}
    {fetch_section assign=carInStockSection section=3 status="V" getImage=true}{if !empty($carInStockSection)}
        <section class="flex:col pad-tb-100">
            <div class="flex:col-max">
                <div class="grid:fr-1 g-gap-20">
                    <div class="text-tmp title-46 all-center"><h2>{$carInStockSection.name}</h2></div>

                    {fetch_model_equipments assign=equipments brands='' limit=4}{if !empty($equipments)}
                        <div class="cars-slider">
                            <div class="swiper cars-slider_js">
                                <div class="swiper-wrapper">
                                    {foreach from=$equipments item=equipment}
                                        {* equipment item *}
                                        <div class="swiper-slide">
                                            {include file="items/equipment.tpl"}
                                        </div>
                                        {* /equipment item *}
                                    {/foreach}
                                </div>
                            </div>
                            <div class="cars-slider__pagination"></div>
                        </div>
                    {/if}
                    <a class="btn accent-2 x-center" href="{$SITE_URL}{$carInStockSection.url}">Посмотреть все</a>
                </div>
            </div>
        </section>
    {/if}
    {* /Авто в наличии *}

    {* О нас *}
    {fetch_section assign=aboutSection section=2 status="V" getImage=true}{if !empty($aboutSection)}
        <section class="about">
            <div class="about__item">
                <div class="text-tmp title-46 color-white">
                    <h2>{$aboutSection.name}</h2>
                    <p>{$aboutSection.content|strip_tags|truncate:324:'' nofilter}</p>
                </div>
                <a class="btn white transparent" href="{$SITE_URL}{$aboutSection.url}">Подробнее</a>
            </div>

            <div class="about__item">
                <div class="about__item-img">
                    <img src="{$ASSETS_URL}/images/common/1.jpg" alt="">
                </div>

                {if !empty($aboutSection.gallery)}
                    <div class="about__slider">

                        <div class="swiper about-slider_js">
                            <div class="swiper-wrapper">
                                {foreach item=gallery from=$aboutSection.gallery name=galleries}
                                    {if $gallery.position eq 'gallery'}
                                        <div class="swiper-slide">
                                            <div class="about__slider-item">
                                                <img src="{$gallery.original}" alt="{$gallery.title}">
                                            </div>
                                        </div>
                                    {/if}
                                {/foreach}
                            </div>
                        </div>

                        <div class="arrows">
                            <button class="arrow-slider about-prev_js">{include file="icon/svg.tpl" svgId="arrowLeft" fill="none"}</button>
                            <button class="arrow-slider about-next_js">{include file="icon/svg.tpl" svgId="arrowRight" fill="none"}</button>
                        </div>
                    </div>
                {/if}

            </div>
        </section>
    {/if}
    {* /О нас *}

    {* Обратная связь *}
    {include file="blocks/feedback.tpl"}
    {* /Обратная связь *}

    {* Дилерские адреса *}
    {fetch_section assign=dealerSection section=17 status="V" getImage=true}{if !empty($dealerSection)}
        <section class=" flex:col pad-tb-100">
            <div class="flex:col-max">
                <div class="grid:fr-1 g-gap-40">
                    <div class="text-tmp title-46 all-center">
                        <h2>{$dealerSection.name}</h2>
                    </div>

                    {fetch_dealers assign=dealers order="orderBy ASC"}{if !empty($dealers)}
                        <div class="dealers tab_js">
                            <div class="dealers__aside">
                                <div class="dealers__aside-inner">
                                    {foreach from=$dealers item=dealer name=dealerItems}
                                        {* dealer item *}
                                        {include file="items/dealer.tpl" dealer=$dealer}
                                        {* /dealer item *}
                                    {/foreach}
                                </div>
                            </div>

                            <div class="dealers__imgs">
                                {foreach from=$dealers item=dealer name=dealerItems}
                                    <img class="tab-drop_js {if $smarty.foreach.dealerItems.first}active{/if}" src="{$dealer.image.original|default:"{$ASSETS_URL}/images/default.jpg" }" alt="{$dealer.title}">
                                {/foreach}
                            </div>
                        </div>
                    {/if}

                </div>
            </div>
        </section>
    {/if}
    {* /Дилеркские адреса *}

</main>

{include file="footer.tpl"}